<?php
defined('YII_ENV') or define('YII_ENV', 'dev');
defined('YII_ENV_TEST') or define('YII_ENV_TEST', false);
$params = require __DIR__ . '/params.php';
$db = require __DIR__ . '/db.php';


$config = [
    'id' => 'basic',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'as cors' => [
        'class' => \yii\filters\Cors::class,
        'cors' => [
            'Origin' => ['*'], // Allow all origins
            'Access-Control-Request-Method' => ['GET', 'POST', 'PUT', 'PATCH', 'DELETE', 'HEAD', 'OPTIONS'],
            'Access-Control-Request-Headers' => ['*'],
            'Access-Control-Allow-Credentials' => null,
            'Access-Control-Max-Age' => 86400,
            'Access-Control-Expose-Headers' => [],
        ],
    ],
    'components' => [
        'request' => [
            'parsers' => [
                'application/json' => 'yii\web\JsonParser',
            ],
            'enableCsrfValidation' => false,  // Disable CSRF validation globally
            // !!! insert a secret key in the following (if it is empty) - this is required by cookie validation
            'cookieValidationKey' => 'u1dzD5dWr92DrUsXn9Ukkzi8wVQqkC5n',
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'user' => [
            'identityClass' => 'app\models\User',
            'enableAutoLogin' => true,
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'mailer' => [
        'class' => \yii\symfonymailer\Mailer::class,
        'viewPath' => '@app/mail',
        // Configure the transport to use SMTP
        'transport' => [
            'class' => 'Swift_SmtpTransport',
            'scheme' => 'smtp',
            'host' => 'mail.escuelaconductores.cl',   // SMTP server (e.g., 'smtp.gmail.com')
            'username' => 'ventas@escuelaconductores.cl',     // Your email address
            'password' => "1?nyd5=$.{9R",        // Your email password
            'port' => 465,                              // SMTP port (587 for TLS)
            'encryption' => 'ssl',                      // Use 'tls' for encryption
        ],
        // Set this to false to actually send emails instead of saving them to files
        'useFileTransport' => false,
    ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'db' => $db,
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
            ],
        ],
    ],
    //'response' => [
        //'format' => yii\web\Response::FORMAT_JSON,
        //'headers' => [
            ////'Access-Control-Allow-Origin' => 'http://localhost:5174/', // Permitir todos los orígenes (reemplazar con una URL específica si es necesario)
            //'Access-Control-Allow-Origin' => '*', // Permitir todos los orígenes (reemplazar con una URL específica si es necesario)
            //'Access-Control-Allow-Methods' => 'GET, POST, PUT, DELETE, OPTIONS', // Métodos permitidos
            //'Access-Control-Allow-Headers' => 'Content-Type, Authorization', // Encabezados permitidos
        //],
    //],
    //'params' => $params,
];

if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];
}

return $config;
