<?php

namespace app\controllers;

use Yii;
use yii\web\Response;
use yii\filters\Cors;
use app\models\Alumno;

class AlumnoController extends \yii\web\Controller
{
    //public function behaviors()
//{
    //return array_merge(parent::behaviors(), [
        //'corsFilter' => [
            //'class' => Cors::class,
            //'cors' => [
                ////'Origin' => ['http://localhost:5174'],
                //'Access-Control-Request-Method' => ['GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'],
                //'Access-Control-Allow-Headers' => ['Content-Type', 'Authorization'],
            //],
        //],
    //]);
//}
    //public function beforeAction($action)
    //{
        //\Yii::$app->response->format = Response::FORMAT_JSON;
        //\Yii::$app->response->headers->set('Access-Control-Allow-Origin', 'http://localhost:5174/');
        //\Yii::$app->response->headers->set('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');
        //\Yii::$app->response->headers->set('Access-Control-Allow-Headers', 'Content-Type, Authorization');

        //return parent::beforeAction($action);
    //}

    public function actionIndex()
    {
        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        $body = Yii::$app->request->getBodyParams();
        $error = Alumno::crearAlumno($body);
        if($error != null) {
            Yii::$app->response->statusCode = 500;
            return [
                "code" => 0,
                "status" => 500,
                "message" => "database error",
                "details" => $error
            ];
        }
        assert($error == null);
        $Alumnos = Yii::$app->db->createCommand("
        SELECT *
        FROM alumno
        WHERE alumno.rut_alumno = :rut_alumno
        ", [
            'rut_alumno' => $body['rut_alumno']
        ])->queryAll();
        //Enviar correo
        Yii::$app->mailer->compose()
        ->setTo($body['correo_electronico_alumno'])
        ->setFrom(["ventas@escuelaconductores.cl" => "Escuela de Conductores ICP"])
        ->setSubject("Se ha recibido su solicitud.")
        ->setTextBody("
        Buenos dias

        Se ha recibido su mensaje. Se le enviara un correo con la respuesta
        a la brevedad

        Contactese con un ejecutivo al siguiente numero +XX XXXX XXXX
        
        Saludos
        ")  
        ->send();
        
        Yii::$app->mailer->compose()
        ->setTo("ventas@escuelaconductores.cl")
        ->setFrom(["ventas@escuelaconductores.cl" => "Escuela de Conductores ICP"])
        ->setSubject("Se envio una solicitud")
        ->setTextBody("
        Buenos dias

        La persona ". $body['nombres_alumno']." " . $body['apellido_paterno_alumno'] . $body['apellido_materno_alumno']. " 
        con rut: ". $body['rut_alumno']."
        fecha_nacimiento_alumno: " . $body['fecha_nacimiento_alumno'] . "
        correo: ". $body['correo_electronico_alumno']."
        telefono: ". $body['telefono_alumno']."
        licencia actual: ". $body['licencia_actual_alumno']."
        licencia interes: ". $body['licencia_interes_alumno']."
        mensaje alumno: ". $body['mensaje_alumno']."

        Se ha enviado el numero +XXX XXXX XXXX al interesado
        ")  
        ->send();

/*
        escolaridad: " . $body['escolaridad'] . "
        profesion: " . ($body['profesion'] ?? "No responde") . "
        domicilio: ". $body['domicilio']."
        comuna: ". $body['comuna']."
*/
        
        if($Alumnos != null) {
            Yii::$app->response->statusCode = 200;
            return [
                'data' => $Alumnos,
                'message' => 'OK'];
        }else {
            Yii::$app->response->statusCode = 400;
            return [
                "code" => 0,
                "status" => 500,
                "message" => "Internal Server Error",
                "details" => "Unexpected error"
            ];
        }
    }
}
