<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "alumno".
 *
 * @property int $id_alumno
 * @property string|null $rut_alumno
 * @property string|null $nombres_alumno
 * @property string|null $apellido_paterno_alumno
 * @property string|null $apellido_materno_alumno
 * @property string|null $correo_electronico_alumno
 * @property string|null $fecha_nacimiento_alumno
 * @property string|null $telefono_alumno
 * @property string|null $licencia_actual_alumno
 * @property string|null $licencia_interes_alumno
 * @property string|null $mensaje_alumno
 */
class Alumno extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'alumno';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['rut_alumno', 'nombres_alumno', 'apellido_paterno_alumno', 'apellido_materno_alumno', 'correo_electronico_alumno', 'fecha_nacimiento_alumno', 'telefono_alumno', 'licencia_actual_alumno', 'licencia_interes_alumno', 'mensaje_alumno'], 'default', 'value' => null],
            [['rut_alumno', 'nombres_alumno', 'apellido_paterno_alumno', 'correo_electronico_alumno', 'fecha_nacimiento_alumno', 'telefono_alumno', 'licencia_actual_alumno', 'licencia_interes_alumno'
            ], 'required', 'message' => 'Este campo es obligatorio'],
            [['fecha_nacimiento_alumno', 'telefono_alumno'], 'safe'],
            [['rut_alumno'], 'string', 'max' => 12],
            [['nombres_alumno', 'apellido_paterno_alumno', 'apellido_materno_alumno', 'correo_electronico_alumno'], 'string', 'max' => 50],
            //[['rut_alumno'], 'unique'],
            //[['correo_electronico_alumno'], 'unique'],
            [['nombres_alumno'], 'match', 'pattern' => '/^[a-zA-Z\s]+$/', 'message' => 'Este campo solo puede llevar letras y espacios'],
            [['apellido_paterno_alumno'], 'match', 'pattern' => '/^[a-zA-Z\s]+$/', 'message' => 'Este campo solo puede llevar letras y espacios'],
            [['apellido_materno_alumno'], 'match', 'pattern' => '/^[a-zA-Z\s]+$/', 'message' => 'Este campo solo puede llevar letras y espacios'],
            [['licencia_actual_alumno', 'licencia_interes_alumno'], 'string', 'max' => 4],
            [['mensaje_alumno'], 'string', 'max' => 1000],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id_alumno' => 'Id Alumno',
            'rut_alumno' => 'Rut Alumno',
            'nombres_alumno' => 'Nombres Alumno',
            'apellido_paterno_alumno' => 'Apellido Paterno Alumno',
            'apellido_materno_alumno' => 'Apellido Materno Alumno',
            'correo_electronico_alumno' => 'Correo Electronico Alumno',
            'fecha_nacimiento_alumno' => 'Fecha Nacimiento Alumno',
            'telefono_alumno' => 'Telefono Alumno',
            'licencia_actual_alumno' => 'Licencia Actual Alumno',
            'licencia_interes_alumno' => 'Licencia Interes Alumno',
            'mensaje_alumno' => 'Mensaje Alumno',
        ];
    }


    public static function crearAlumno($body) {
        $model = new Alumno();
        if($model->load($body, '')) {
            if($model->validate()) {
                try {
                    Yii::$app->db->createCommand("
                   INSERT INTO alumno
                    (
                    rut_alumno,
                    nombres_alumno, 
                    apellido_paterno_alumno,
                    apellido_materno_alumno,
                    correo_electronico_alumno,
                    fecha_nacimiento_alumno,
                    telefono_alumno,
                    licencia_actual_alumno,
                    licencia_interes_alumno,
                    mensaje_alumno
                    )
                    VALUES
                    (
                    :rut_alumno,
                    :nombres_alumno,
                    :apellido_paterno_alumno,
                    :apellido_materno_alumno,
                    :correo_electronico_alumno,
                    :fecha_nacimiento_alumno,
                    :telefono_alumno,
                    :licencia_actual_alumno,
                    :licencia_interes_alumno,
                    :mensaje_alumno
                    )
                    ", [
                    'rut_alumno' => $body['rut_alumno'],
                    'nombres_alumno' => $body['nombres_alumno'],
                    'apellido_paterno_alumno' => $body['apellido_paterno_alumno'],
                    'apellido_materno_alumno' => $body['apellido_materno_alumno'],
                    'correo_electronico_alumno' => $body['correo_electronico_alumno'],
                    'fecha_nacimiento_alumno' => $body['fecha_nacimiento_alumno'],
                    'telefono_alumno' => $body['telefono_alumno'],
                    'licencia_actual_alumno' => $body['licencia_actual_alumno'],
                    'licencia_interes_alumno' => $body['licencia_interes_alumno'],
                    'mensaje_alumno' => $body['mensaje_alumno']
                    ])->execute();

                }catch(\yii\db\Exception $e) {
                    return $e->getMessage();
                }catch(\Exception $e) {
                    return $e->getMessage();
                }
                return null;
            }else {
                
            }
        }
        return $model->errors;
    }
}
